﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Entities
{
    public enum SteeringBehavior
    {
        Seek,
        Flee,
        Arrive,
        Pursuit,
        Evade,
        Seperation
    }


    public class SteeringComponent : Component
    {
        PhysicsComponent physics;
        Vector2 steeringForce;
        Dictionary<SteeringBehavior, bool> steeringBehaviors = new Dictionary<SteeringBehavior, bool>();

        public Vector2 TargetPosition { get; set; }
        public Entity TargetEntity { get; set; }
        public List<Entity> Neighbors { get; set; }

        public SteeringComponent(string name)
            : base(name)
        {
            steeringBehaviors.Add(SteeringBehavior.Arrive, false);
            steeringBehaviors.Add(SteeringBehavior.Evade, false);
            steeringBehaviors.Add(SteeringBehavior.Flee, false);
            steeringBehaviors.Add(SteeringBehavior.Pursuit, false);
            steeringBehaviors.Add(SteeringBehavior.Seek, false);
            steeringBehaviors.Add(SteeringBehavior.Seperation, false);
        }

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {


            // The worst fix ever...

            if (!steeringBehaviors[SteeringBehavior.Arrive] && !steeringBehaviors[SteeringBehavior.Evade] &&
                !steeringBehaviors[SteeringBehavior.Flee] && !steeringBehaviors[SteeringBehavior.Pursuit] &&
                !steeringBehaviors[SteeringBehavior.Seek] && !steeringBehaviors[SteeringBehavior.Seperation])
            {
                return;
            }




            float elapsed = (float)gameTime.ElapsedRealTime.Milliseconds;
            Vector2 SteeringForce = Calculate();
            Vector2 acceleration = SteeringForce / physics.Mass;

            physics.Velocity.X += acceleration.X;// *elapsed;
            physics.Velocity.Y += acceleration.Y;// *elapsed;
            
            
            //Velocity.Truncate;
            if (physics.Velocity.Length() > physics.MaxSpeed)
            {
                physics.Velocity.Normalize();
            }

            Entity.Position.X += physics.Velocity.X;// *elapsed;
            Entity.Position.Y += physics.Velocity.Y;// *elapsed;

            if (physics.Velocity.LengthSquared() > 0.0000001f)
            {
                physics.Velocity.Normalize();
                physics.Heading = physics.Velocity;

                physics.Side = new Vector2(-physics.Heading.Y, physics.Heading.X);
                //Side = Heading.Perp();
            }
        }

        private Vector2 Calculate()
        {
            steeringForce = Vector2.Zero;
            Vector2 force;
            
            if (steeringBehaviors[SteeringBehavior.Seek])
            {
                force = Seek(TargetPosition); //* 1;

                if (!AccumulateForce(ref steeringForce, force))
                {
                    return steeringForce;
                }
            }

            if (steeringBehaviors[SteeringBehavior.Flee])
            {
                force = Flee(TargetPosition) * 1;

                if (!AccumulateForce(ref steeringForce, force))
                {
                    return steeringForce;
                }
            }

            if (steeringBehaviors[SteeringBehavior.Arrive])
            {
                force = Arrive(TargetPosition,1) * 1;

                if (!AccumulateForce(ref steeringForce, force))
                {
                    return steeringForce;
                }
            }

            if (steeringBehaviors[SteeringBehavior.Evade])
            {
                force = Evade(TargetEntity) * 1;

                if (!AccumulateForce(ref steeringForce, force))
                {
                    return steeringForce;
                }
            }

            if (steeringBehaviors[SteeringBehavior.Evade])
            {
                force = Evade(TargetEntity) * 1;

                if (!AccumulateForce(ref steeringForce, force))
                {
                    return steeringForce;
                }
            }

            if (steeringBehaviors[SteeringBehavior.Seperation])
            {
                force = Seperation(Neighbors);

                if (!AccumulateForce(ref steeringForce, force))
                {
                    return steeringForce;
                }
            }


            return steeringForce;
        }

        public void ToggleSteeringBehavior(SteeringBehavior behavior, bool on)
        {
            steeringBehaviors[behavior] = on;
        }

        bool AccumulateForce(ref Vector2 runningTotal, Vector2 forceToAdd)
        {
            float magnitudeSoFar = runningTotal.Length();
            float magnitudeRemaining = physics.MaxForce - magnitudeSoFar;

            if (magnitudeRemaining <= 0f)
            {
                return false;
            }

            float magnitideToAdd = forceToAdd.Length();

            if (magnitideToAdd < magnitudeRemaining)
            {
                runningTotal += forceToAdd;
            }
            else
            {
                runningTotal += Vector2.Normalize(forceToAdd) * magnitudeRemaining;
            }

            return true;

        }

        public Vector2 Seek(Vector2 TargetPos)
        {
            Vector2 DesiredVelocity = Vector2.Normalize(TargetPos - Entity.Position
                * physics.MaxSpeed);
            return (DesiredVelocity - physics.Velocity);
        }

        public Vector2 Flee(Vector2 TargetPos)
        {
            Vector2 DesiredVelocity = Vector2.Normalize(Entity.Position - TargetPos
                * physics.MaxSpeed);
            return (DesiredVelocity - physics.Velocity);
        }

        public Vector2 Arrive(Vector2 TargetPos, int deceleration)
        {
            Vector2 toTarget = TargetPos - Entity.Position;
            float distance = toTarget.Length();

            if (distance > 0)
            {
                if (distance < 1)
                {
                    int i = 5;
                    i++;
                }

                float decelerationTweaker = 0.3f;

                float speed = distance / (float)deceleration * decelerationTweaker;
                Vector2 desiredVelocity = toTarget * speed / distance;

                return (desiredVelocity - physics.Velocity);
            }
            return Vector2.Zero;
        }

        public Vector2 Pursuit(Entity evader)
        {
            Vector2 toEvader = evader.Position - Entity.Position;

            PhysicsComponent evaderPhysics = (PhysicsComponent)evader.GetComponent("physics");
            float relativeHeading = Vector2.Dot(physics.Heading, evaderPhysics.Heading);


            if (Vector2.Dot(toEvader, physics.Heading) > 0 &&
                (relativeHeading < -0.95f))
            {
                return Seek(evader.Position);
            }

            float lookAheadTime = toEvader.Length() / physics.MaxSpeed + evaderPhysics.MaxSpeed;

            return Seek(evader.Position + evaderPhysics.Velocity * lookAheadTime);
        }

        public Vector2 Evade(Entity pursuer)
        {
            Vector2 toPursuer = pursuer.Position - Entity.Position;

            PhysicsComponent pursuervaderPhysics = (PhysicsComponent)pursuer.GetComponent("physics");
            float relativeHeading = Vector2.Dot(physics.Heading, pursuervaderPhysics.Heading);

            float lookAheadTime = toPursuer.Length() / physics.MaxSpeed + pursuervaderPhysics.MaxSpeed;

            return Flee(pursuer.Position + pursuervaderPhysics.Velocity * lookAheadTime);
        }

        public Vector2 Seperation(List<Entity> entities)
        {
            Vector2 steeringForce = Vector2.Zero;

            for (int i = 0; i < entities.Count; i++)
            {
                if (entities[i] != Entity)
                {
                    Vector2 toAgent = Entity.Position - entities[i].Position;

                    steeringForce += Vector2.Normalize(toAgent) / toAgent.Length();
                }
            }

            return steeringForce;
        }



        public override void OnAttached(Entity entity)
        {
            physics = (PhysicsComponent)entity.GetComponent("physics");

            base.OnAttached(entity);
        }
    }
}
